<?php

namespace App\Http\Controllers;

use App\Http\Controllers\ApiGamesController;
use App\Http\Controllers\BxystoreController;
use App\Http\Controllers\digiFlazzController;
use App\Http\Controllers\SmileOneController;
use App\Http\Controllers\VipResellerController;
use App\Models\Kategori;
use App\Models\Layanan;
use App\Models\Pembayaran;
use App\Models\Pembelian;
use App\Models\Seting;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Storage;

class PaydisiniController extends Controller
{
    private const PAYMENT_CHANNELS = [
        'BCAVA' => [
            'id' => 1,
            'min' => 10000,
            'max' => 10000000,
            'fee' => 4900
        ],
        'BRIVA' => [
            'id' => 2,
            'min' => 10000,
            'max' => 50000000,
            'fee' => 2500
        ],
        'CIMBVA' => [
            'id' => 3,
            'min' => 10000,
            'max' => 50000000,
            'fee' => 2500
        ],
        'BNIVA' => [
            'id' => 4,
            'min' => 10000,
            'max' => 50000000,
            'fee' => 4000
        ],
        'MANDIRIVA' => [
            'id' => 5,
            'min' => 10000,
            'max' => 50000000,
            'fee' => 2500
        ],
        'PERMATAVA' => [
            'id' => 7,
            'min' => 10000,
            'max' => 50000000,
            'fee' => 2500
        ],
        'DANAMONVA' => [
            'id' => 8,
            'min' => 10000,
            'max' => 50000000,
            'fee' => 2500
        ],
        'BSIVA' => [
            'id' => 9,
            'min' => 10000,
            'max' => 50000000,
            'fee' => 3500
        ],
        'BNCVA' => [
            'id' => 10,
            'min' => 10000,
            'max' => 50000000,
            'fee' => 3500
        ],
        'QRIS' => [
            'id' => 11,
            'min' => 100,
            'max' => 10000000,
            'fee_percentage' => 0.7
        ],
        'OVO' => [
            'id' => 12,
            'min' => 1000,
            'max' => 2000000,
            'fee_percentage' => 3
        ],
        'DANA' => [
            'id' => 13,
            'min' => 1000,
            'max' => 2000000,
            'fee_percentage' => 3
        ],
        'LINKAJA' => [
            'id' => 14,
            'min' => 1000,
            'max' => 2000000,
            'fee_percentage' => 3
        ],
        'QRISCUSTOM' => [
            'id' => 17,
            'min' => 100,
            'max' => 10000000,
            'fee_percentage' => 0.7
        ],
        'ALFAMART' => [
            'id' => 18,
            'min' => 10000,
            'max' => 5000000,
            'fee' => 2500
        ],
        'INDOMARET' => [
            'id' => 19,
            'min' => 10000,
            'max' => 5000000,
            'fee' => 2500
        ],
        'QRISDANAMON' => [
            'id' => 20,
            'min' => 1000,
            'max' => 10000000,
            'fee_percentage' => 0.9
        ],
        'OCBCVA' => [
            'id' => 21,
            'min' => 10000,
            'max' => 50000000,
            'fee' => 1500
        ],
        'MUAMALATVA' => [
            'id' => 22,
            'min' => 10000,
            'max' => 50000000,
            'fee' => 3500
        ]
    ];

    public function requestPay($uniqueCode, $channel, $amount, $note, $nomor)
    {
        try {
            if (!isset(self::PAYMENT_CHANNELS[$channel])) {
                throw new Exception("Invalid payment channel selected");
            }

            $channelData = self::PAYMENT_CHANNELS[$channel];

            // Validate amount range
            if ($amount < $channelData['min'] || $amount > $channelData['max']) {
                throw new Exception("Amount must be between Rp " . number_format($channelData['min']) . " and Rp " . number_format($channelData['max']) . " for {$channel}");
            }

            $settings = Seting::first();
            
            $payload = [
                'key' => $settings->paydisini_key,
                'request' => 'new',
                'merchant_id' => $settings->paydisini_id,
                'unique_code' => $uniqueCode,
                'service' => $channelData['id'],
                'ewallet_phone' => $nomor,
                'amount' => $amount,
                'note' => $note,
                'valid_time' => 1800,
                'type_fee' => 1,
                'payment_guide' => true,
                'signature' => md5($settings->paydisini_key . $uniqueCode . $channelData['id'] . $amount . 1800 . 'NewTransaction')
            ];

            // Initialize cURL session
            $curl = curl_init('https://api.paydisini.co.id/v1/');

            // Set cURL options
            curl_setopt_array($curl, [
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_POST => true,
                CURLOPT_POSTFIELDS => http_build_query($payload),
                CURLOPT_HTTPHEADER => [
                    'Content-Type: application/x-www-form-urlencoded',
                    'Accept: application/json'
                ],
                CURLOPT_TIMEOUT => 30,
                CURLOPT_SSL_VERIFYPEER => true
            ]);

            // Execute the request
            $response = curl_exec($curl);
            $httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);

            // Check for cURL errors
            if (curl_errno($curl)) {
                throw new Exception('cURL Error: ' . curl_error($curl));
            }

            curl_close($curl);

            // Decode JSON response
            $paydisinires = json_decode($response, true);
            if ($httpCode !== 200 || !$paydisinires) {
                throw new Exception('Invalid API response received');
            }

            if (!$paydisinires['success']) {
                return [
                    'success' => false,
                    'msg' => $paydisinires['msg']
                ];
            }

            return [
                'success' => true,
                'no_pembayaran' => $this->determinePaymentReference($paydisinires['data']),
                'reference' => $paydisinires['data']['pay_id'],
                'amount' => $paydisinires['data']['amount']
            ];
        } catch (Exception $e) {
            return [
                'success' => false,
                'msg' => $e->getMessage()
            ];
        }
    }
    private function determinePaymentReference($paymentData)
    {
        if (isset($paymentData['payment_code'])) {
            return $paymentData['payment_code'];
        }

        if (isset($paymentData['virtual_account'])) {
            return $paymentData['virtual_account'];
        }

        if (isset($paymentData['qrcode_url'])) {
            return $paymentData['qrcode_url'];
        }

        return $paymentData['checkout_url'];
    }
    public function callback(Request $request)
    {
        // IP Whitelist validation
        if ($request->ip() !== '45.87.242.188') {
            Log::warning('Unauthorized callback IP: ' . $request->ip());
            return response()->json(['success' => true]);
        }

        $settings = Seting::first();
         $api = \DB::table('setings')->where('id', 1)->first();
        $requiredFields = ['key', 'pay_id', 'unique_code', 'status', 'signature'];

        // Basic request validation
        if ($request->key !== $settings->paydisini_key || !$request->has($requiredFields)) {
            Log::error('Invalid callback parameters', [
                'unique_code' => $request->unique_code ?? null
            ]);
            return response()->json(['success' => true]);
        }

        // Fetch payment record
        $payment = Pembayaran::where('reference', $request->pay_id)
            ->where('status', 'Belum Lunas')
            ->first();

        if (!$payment) {
            Log::error('Payment not found', [
                'reference' => $request->unique_code,
                'pay_id' => $request->pay_id
            ]);
            return response()->json(['success' => true]);
        }

        // Update payment status to "Lunas"
        $payment->status = 'Lunas';
        $payment->save();

        // Validate signature after confirming payment existence
        $expectedSignature = md5($settings->paydisini_key . $payment->order_id . 'CallbackStatus');
        if ($request->signature !== $expectedSignature) {
            Log::error('Invalid signature for payment', [
                'kira' => $expectedSignature,
                'ternyata' => $request->signature
            ]);
            return response()->json(['success' => true]);
        }

        $purchase = Pembelian::where('order_id', $payment->order_id)->where('status', 'Pending')->first();
        if (!$purchase) {
            Log::error('Purchase not found for payment', [
                'order_id' => $payment->order_id,
                'reference' => $request->pay_id
            ]);
            return response()->json(['success' => true]);
        }

        $service = Layanan::where('layanan', $purchase->layanan)
            ->where('status', 'available')
            ->first();

        if (!$service) {
            Log::error('Service unavailable', [
                'layanan' => $purchase->layanan,
                'order_id' => $payment->order_id
            ]);
            return response()->json(['success' => true]);
        }

        if ($service->provider == 'digiflazz') {
            $digiFlazz = new digiFlazzController;

            $order = $digiFlazz->order(
                $purchase->user_id,
                $purchase->zone,
                $service->provider_id,
                $purchase->order_id
            );

            // Update purchase with common fields
            $purchase->log = $order;
            $purchase->provider_order_id = $order['data']['ref_id'];
            Log::error('order', [
    'order' => $order
]);

            if ($order['data']['status'] == "Gagal") {
                $purchase->update([
                    'status' => 'Batal',
                    'keterangan' => 'Gagal diproses...'
                ]);
            } else {
                $purchase->update([
                    'status' => 'Process',
                    'keterangan' => 'Sedang diproses...',
                    'transaction_id' => $purchase->order_id
                ]);
                // Notify admin
        $pesanAdmin = "*Halo Admin " . env("APP_NAME") . " Ada Pesanan Baru Nih!*

" .
        "*Informasi pembelian:*
" .
        "*Invoice:* {$purchase->order_id}
" .
        "*Item:* {$purchase->layanan}
" .
        "*User ID:* {$purchase->user_id} ({$purchase->zone})
" .
        "*Pembayaran:* {$payment->metode} - Rp. " . number_format($payment->harga, 0, '.', ',') . "

" .
        "*Nomor Pembeli:* {$payment->no_pembeli}

" .
        "──────────────────────────────
";

    $this->msg(env('NOMOR_ADMIN'), $pesanAdmin);
            }
        } elseif ($service->provider == 'bxystore') {
            $bxystore = new BxystoreController;
            $order = $bxystore->order(
                $purchase->user_id,
                $purchase->zone,
                $service->provider_id,
                $purchase->kontak,
                $purchase->order_id
            );

            $purchase->log = $order;
            $purchase->provider_order_id = $order['data']['id'];
Log::error('order', [
    'order' => $order
]);

            if (isset($order['status']) && $order['status'] === true) {
                $purchase->update([
                    'status' => 'Process',
                    'keterangan' => 'Sedang diproses...',
                    'transaction_id' => $order['data']['id'] ?? $purchase->order_id
                ]);
                // Notify admin
        $pesanAdmin = "*Halo Admin " . env("APP_NAME") . " Ada Pesanan Baru Nih!*

" .
        "*Informasi pembelian:*
" .
        "*Invoice:* {$purchase->order_id}
" .
        "*Item:* {$purchase->layanan}
" .
        "*User ID:* {$purchase->user_id} ({$purchase->zone})
" .
        "*Pembayaran:* {$payment->metode} - Rp. " . number_format($payment->harga, 0, '.', ',') . "

" .
        "*Nomor Pembeli:* {$payment->no_pembeli}

" .
        "──────────────────────────────
";

    $this->msg(env('NOMOR_ADMIN'), $pesanAdmin);
            } else {
                $purchase->update([
                    'status' => 'Batal',
                    'keterangan' => $order['msg'] ?? 'Gagal diproses...'
                ]);
            }
        } elseif ($service->provider == 'joki') {
    // Logika untuk provider joki
    $purchase->update([
        'status' => 'Process',
        'keterangan' => 'Sedang diproses oleh tim joki...'
    ]);

    // Kirimkan notifikasi pembelian ke admin
    $pesanAdmin = "*Halo Admin " . env("APP_NAME") . " Ada Pesanan Baru Nih!*

" .
        "*Informasi pembelian:*
" .
        "*Invoice:* {$purchase->order_id}
" .
        "*Item:* {$purchase->layanan}
" .
        "*User ID:* {$purchase->user_id} ({$purchase->zone})
" .
        "*Pembayaran:* {$payment->metode} - Rp. " . number_format($payment->harga, 0, '.', ',') . "

" .
        "*Nomor Pembeli:* {$payment->no_pembeli}

" .
        "──────────────────────────────
";

    $this->msg(env('NOMOR_ADMIN'), $pesanAdmin);
}else {
            Log::error('Invalid provider configuration', [
                'provider' => $service->provider,
                'order_id' => $purchase->order_id
            ]);
            return response()->json(['success' => true]);
        }

        return response()->json(['success' => true]);
    }
    
    
    public function msg($nomor, $msg)
    {
        $api = \DB::table('setings')->where('id', 1)->first();
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://api.fonnte.com/send',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => array('target' => $nomor, 'message' => $msg),
            CURLOPT_HTTPHEADER => array(
               'Authorization: ' . $api->wa_key
            ),
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        return $response;
    }
    
}